﻿namespace com.blong.googleapi.map;

interface

uses
  android.content,
  android.location,
  android.graphics,
  android.util,
  com.google.android.maps;

type
  MyGoogleMapLocationOverlay2 = public class(MyGoogleMapLocationOverlay)
  private
    const Tag = 'MyGoogleMapLocationOverlay2';
    var customLocationOverlay: CircleOverlay;
    var locMgr: LocationManager;
  public
    constructor (aContext: Context; aMapView: MapView);
    method onLocationChanged(loc: Location); override;
  end;

implementation

constructor MyGoogleMapLocationOverlay2(aContext: Context; aMapView: MapView);
begin
  inherited;
  locMgr := LocationManager(ctx.SystemService[Context.LOCATION_SERVICE]);
end;

method MyGoogleMapLocationOverlay2.onLocationChanged(loc: Location);
const
  CircleRadius = 0.25; //miles
  MperMile = 1609.344;
begin
  inherited;
  //Ignore locations from the network provider if the GPS provider is active
  if locMgr.isProviderEnabled(LocationManager.GPS_PROVIDER) and 
     (loc.Provider = locMgr.Provider[LocationManager.NETWORK_PROVIDER]) then
    exit;
  Log.i(Tag, 'onLocationChanged: ' + loc.Provider);
  if customLocationOverlay <> nil then
  begin
    var idx := map.Overlays.indexOf(customLocationOverlay);
    if idx <> -1 then
      map.Overlays.remove(idx);
  end;
  //Set up a base circle of 1/4 mile
  var radius := CircleRadius * MperMile;
  //if the location contains accuracy data we'll use that instead as a radius
  if loc.hasAccuracy then
  begin
    radius := loc.Accuracy;
    Log.i(Tag, WideString.format('Accuracy attained = %f', loc.Accuracy));
  end;
  customLocationOverlay := new CircleOverlay(loc.Latitude, loc.Longitude,
    radius, Color.BLUE);
  map.Overlays.add(customLocationOverlay);
end;

end.