﻿namespace com.blong.googleapi.map;

interface

uses
  android.content,
  android.location,
  com.google.android.maps;

type
  /// <summary>
  /// Descendant of MyLocationOverlay that ensures the current
  /// location is kept in view on the screen on every location update
  /// </summary>
  MyGoogleMapLocationOverlay = public class(MyLocationOverlay)
  protected
    map: MapView;
    ctx: Context;
  public
    constructor (aContext: Context; aMapView: MapView);
    method onLocationChanged(loc: Location); override;
  end;

implementation

constructor MyGoogleMapLocationOverlay(aContext: Context; aMapView: MapView);
begin
  inherited;
  map := aMapView;
  ctx := aContext;
end;

/// <summary>
/// When a new location is detected (which could just be a refinement of the
/// same location), check if it is approaching the edge of the visible map
/// (or beyond it) and if so, reposition the map
/// </summary>
/// <param name="loc">the current location data</param>
method MyGoogleMapLocationOverlay.onLocationChanged(loc: Location);
const 
  thresholdRatio = 0.5;
begin
  inherited;
  var mapCenter := map.MapCenter;
  var lat := Integer(loc.Latitude * 1E6);
  var lon := Integer(loc.Longitude * 1E6);
  var latThreshold := thresholdRatio * map.LatitudeSpan / 2;
  var longThreshold := thresholdRatio * map.LongitudeSpan / 2;
  if (lat < mapCenter.LatitudeE6 - latThreshold) or 
     (lat > mapCenter.LatitudeE6 + latThreshold) or
     (lon < mapCenter.LongitudeE6 - longThreshold) or
     (lon > mapCenter.LongitudeE6 + longThreshold) then
    map.Controller.animateTo(new GeoPoint(lat, lon))
end;

end.