﻿namespace com.blong.googleapi.map;

interface

uses 
  android.content,
  android.graphics,
  com.google.android.maps;

type
  /// <summary>
  /// Custom overlay that draw a circle on the map centered at a given point with a given colour
  /// </summary>
  CircleOverlay = public class(Overlay)
  private
    var lat: Double;
    var lon: Double;
    var circleRadius: Double;
    var circleColour: Integer;
  protected
  public
    //This takes the radius in metres
    constructor(latitude, longitude, radius: Double; colour: Integer);
    method draw(overlayCanvas: Canvas; map: MapView; shadow: Boolean); override;
  end;

implementation

constructor CircleOverlay(latitude, longitude, radius: Double; colour: Integer);
begin
  inherited constructor;
  lat := latitude;
  lon := longitude;
  circleRadius := radius;
  circleColour := colour;
end;

method CircleOverlay.draw(overlayCanvas: Canvas; map: MapView; shadow: Boolean);
begin
  inherited;
  var proj := map.Projection;
  var pt := new Point;
  var geo := new GeoPoint(Integer(lat * 1E6), Integer(lon * 1E6));
  proj.toPixels(geo, pt);
  //Get pixel value based on zoom level and corrected for height above/below the equator
  var actualRadius := proj.metersToEquatorPixels(circleRadius) / Math.cos(Math.toRadians(lat));

  //Do very transparent solid circle
  var circlePaint := new Paint;
  circlePaint.Color := (circleColour and $00FFFFFF) or $0F000000;
  circlePaint.Style := Paint.Style.FILL;
  overlayCanvas.drawCircle(pt.x, pt.y, actualRadius, circlePaint);

  //Now do thin, solid circle border
  var borderPaint := new Paint;
  borderPaint.AntiAlias := true;
  borderPaint.Color := circleColour or $FF000000;
  borderPaint.Style := Paint.Style.STROKE;
  borderPaint.StrokeWidth := 1;
  overlayCanvas.drawCircle(pt.x, pt.y, actualRadius, borderPaint)
end;

end.