﻿namespace com.blong.googleapi;

//Sample app by Brian Long (http://blong.com)

interface

uses
  java.util,
  android.os,
  android.app,
  android.util,
  android.view,
  android.content,
  android.widget,
  android.net;
  
type
  /// <summary>
  /// Main activity that presents a list of options to the user. Each
  /// option starts a new activity.
  /// </summary>
  MainActivity = public class(ListActivity)
  private 
    //List items;
    const ID_MAP = 0;
    const ID_MAP_OVERLAY_1 = 1;
    const ID_MAP_OVERLAY_2 = 2;
    const ID_MAP_OVERLAY_3 = 3;
    const ID_MAP_OVERLAY_4 = 4;
    //Misc
    const Tag = "GoogleApp.MainActivity";
  public
    method onCreate(savedInstanceState: Bundle); override;
    method onCreateOptionsMenu(mnu: Menu): Boolean; override;
    method onOptionsItemSelected(item: MenuItem): Boolean; override;
    method onBackPressed; override;
    method onListItemClick(l: ListView; v: View; position: Integer; id: Int64); override;
  end;

implementation

method MainActivity.onCreate(savedInstanceState: Bundle);
begin
  inherited;
  //Set up for an icon on the main activity title bar
  requestWindowFeature(Window.FEATURE_LEFT_ICON);
  //Set our view from the "main" layout resource
  setContentView(R.layout.main);
  //Now get the icon on the title bar
  FeatureDrawableResource[Window.FEATURE_LEFT_ICON] := R.drawable.icon;
  var rows := Resources.StringArray[R.array.menu_titles];
  var rowSubtitles := Resources.StringArray[R.array.menu_subtitles];
  if rows.length <> rowSubtitles.length then
    Log.e(Tag, "Menu titles & subtitles have mismatched lengths");
  var listViewContent := new ArrayList<Map<String, Object>>();
  for i: Integer := 0 to rows.length - 1 do
  begin
    var map := new HashMap<String, Object>();
    map.put("heading", rows[i]);
    map.put("subheading", rowSubtitles[i]);
    listViewContent.add(map);
  end;
  //Set up adapter for the ListView using a custom list item template
  ListAdapter := new SimpleAdapter(self, listViewContent, R.layout.listitem_twolines,
      ["heading", "subheading"], [Android.R.id.text1, Android.R.id.text2]);
end;

method MainActivity.onCreateOptionsMenu(mnu: Menu): Boolean;
begin
  MenuInflater.inflate(R.menu.main, mnu);
  exit inherited  
end;

method MainActivity.onOptionsItemSelected(item: MenuItem): Boolean;
begin
  if item.ItemId = R.id.main_menu_about then
  begin
    startActivity(new Intent(self, typeOf(AboutActivity)));
    exit True
  end;
  exit False;
end;

method MainActivity.onBackPressed;
begin
  Toast.makeText(self, String[R.string.back_pressed], Toast.LENGTH_SHORT).show;
  //If you want to disable the back button, don't call inherited method
  inherited
end;

method MainActivity.onListItemClick(l: ListView; v: View; position: Integer; id: Int64);
begin
  case position of
    ID_MAP:             startActivity(new Intent(self, typeOf(GoogleMapActivity)));
    ID_MAP_OVERLAY_1:   startActivity(new Intent(self, typeOf(GoogleMapOverlay1Activity)));
    ID_MAP_OVERLAY_2:   startActivity(new Intent(self, typeOf(GoogleMapOverlay2Activity)));
    ID_MAP_OVERLAY_3:   startActivity(new Intent(self, typeOf(GoogleMapOverlay3Activity)));
    ID_MAP_OVERLAY_4:   startActivity(new Intent(self, typeOf(GoogleMapOverlay4Activity)));
  end;
end;

end.