﻿namespace com.blong.googleapi;

interface

uses
  java.util,
  android.app,
  android.content,
  android.graphics,
  android.graphics.drawable,
  android.os,
  android.util,
  android.view,
  android.widget,
  android.location,
  com.google.android.maps,
  com.blong.googleapi.map;

type
  GoogleMapOverlay4Activity = public class(MapActivity)
  private
    var map: MapView;
    var itemisedOverlay: AnnotationOverlay;
    var marker: Drawable;
    var annotation: OverlayItem;
  protected
    method isLocationDisplayed: Boolean; override;
    method isRouteDisplayed: Boolean; override;
  public
    method onCreate(savedInstanceState: Bundle); override;
    method onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean; override;
  end;

implementation

method GoogleMapOverlay4Activity.onCreate(savedInstanceState: Bundle);
begin
  inherited;
  ContentView := R.layout.googlemapactivity;
  map := MapView(findViewById(R.id.mapView));
  map.BuiltInZoomControls := true;
  map.Satellite := true;
  map.Controller.Zoom := 18;
  marker := Resources.Drawable[R.drawable.androidmarker];
  itemisedOverlay := new AnnotationOverlay(marker, self);
  var point := new GeoPoint(Integer(37.422006 * 1E6), Integer(-122.084095 * 1E6));
  annotation := new OverlayItem(point, 'Google lives here!', 'O HAI G009L3 !!1!');
  itemisedOverlay.addOverlay(annotation);
  map.Overlays.add(itemisedOverlay);
  map.Controller.animateTo(point);
end;

method GoogleMapOverlay4Activity.isLocationDisplayed: Boolean;
begin
  exit True;
end;

method GoogleMapOverlay4Activity.isRouteDisplayed: Boolean;
begin
  exit False;
end;

method GoogleMapOverlay4Activity.onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean;
begin
  var mc := map.Controller;
  case keyCode of 
    KeyEvent.KEYCODE_3: mc.zoomIn;
    KeyEvent.KEYCODE_1: mc.zoomOut;
  end;
  exit inherited;
end;

end.
