﻿namespace com.blong.googleapi;

interface

uses
  java.util,
  android.app,
  android.content,
  android.os,
  android.util,
  android.view,
  android.widget, 
  com.blong.googleapi.map,
  com.google.android.maps;

type
  GoogleMapOverlay3Activity = public class(MapActivity)
  private
    var map: MapView;
    var locationOverlay: MyLocationOverlay;
  protected
    method isLocationDisplayed: Boolean; override;
    method isRouteDisplayed: Boolean; override;
  public
    method onCreate(savedInstanceState: Bundle); override;
    method onResume; override;
    method onPause; override;
    method onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean; override;
  end;

implementation

method GoogleMapOverlay3Activity.onCreate(savedInstanceState: Bundle);
begin
  inherited;
  // Set our view from the "GoogleMapActivity" layout resource
  ContentView := R.layout.googlemapactivity;
  map := MapView(findViewById(R.id.mapView));
  map.BuiltInZoomControls := true;
  map.Satellite := true;
  var controller := map.Controller;
  controller.Zoom := 15;
  //Create a MyLocationOverlay
  locationOverlay := new MyGoogleMapLocationOverlay2(self, map);
  //*Don't* add the overlay onto the map
  //map.Overlays.add(locationOverlay);
  //When the location-aware overlay gets its first fix on our position
  //make sure it brings our position into view
  locationOverlay.runOnFirstFix(new interface Runnable(run := 
    () -> controller.animateTo(locationOverlay.MyLocation)));
end;

method GoogleMapOverlay3Activity.onResume;
begin
  inherited;
  locationOverlay.enableMyLocation;
end;

method GoogleMapOverlay3Activity.onPause;
begin
  locationOverlay.disableMyLocation;
  inherited;
end;

method GoogleMapOverlay3Activity.isLocationDisplayed: Boolean;
begin
  exit true
end;

method GoogleMapOverlay3Activity.isRouteDisplayed: Boolean;
begin
  exit false
end;

method GoogleMapOverlay3Activity.onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean;
begin
  case keyCode of 
    KeyEvent.KEYCODE_3: map.Controller.zoomIn;
    KeyEvent.KEYCODE_1: map.Controller.zoomOut;
  end;
  exit inherited;
end;

end.