﻿namespace com.blong.googleapi;

interface

uses
  java.util,
  android.app,
  android.content,
  android.os,
  android.util,
  android.view,
  android.widget, 
  com.google.android.maps;

type
  GoogleMapOverlay1Activity = public class(MapActivity)
  private
    var map: MapView;
    var locationOverlay: MyLocationOverlay;
  protected
    method isLocationDisplayed: Boolean; override;
    method isRouteDisplayed: Boolean; override;
  public
    method onCreate(savedInstanceState: Bundle); override;
    method onResume; override;
    method onPause; override;
    method onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean; override;
  end;

implementation

method GoogleMapOverlay1Activity.onCreate(savedInstanceState: Bundle);
begin
  inherited;
  // Set our view from the "GoogleMapActivity" layout resource
  ContentView := R.layout.googlemapactivity;
  map := MapView(findViewById(R.id.mapView));
  map.BuiltInZoomControls := true;
  map.Satellite := true;
  var controller := map.Controller;
  controller.Zoom := 15;
  //Create a MyLocationOverlay
  locationOverlay := new MyLocationOverlay(self, map);
  //Add the overlay onto the map
  map.Overlays.add(locationOverlay);
  //When the location-aware overlay gets its first fix on our position
  //make sure it brings our position into view
  locationOverlay.runOnFirstFix(new interface Runnable(run := 
    () -> controller.animateTo(locationOverlay.MyLocation)));
end;

method GoogleMapOverlay1Activity.onResume;
begin
  inherited;
  locationOverlay.enableMyLocation;
  locationOverlay.enableCompass;
end;

method GoogleMapOverlay1Activity.onPause;
begin
  locationOverlay.disableMyLocation;
  locationOverlay.disableCompass;
  inherited;
end;

method GoogleMapOverlay1Activity.isLocationDisplayed: Boolean;
begin
  //Note we *are* now displaying the device location
  exit true
end;

method GoogleMapOverlay1Activity.isRouteDisplayed: Boolean;
begin
  exit false
end;

method GoogleMapOverlay1Activity.onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean;
begin
  case keyCode of 
    KeyEvent.KEYCODE_3: map.Controller.zoomIn;
    KeyEvent.KEYCODE_1: map.Controller.zoomOut;
  end;
  exit inherited;
end;

end.
