﻿namespace com.blong.googleapi;

interface

uses
  java.util,
  android.app,
  android.content,
  android.os,
  android.util,
  android.view,
  android.widget, 
  com.google.android.maps;

type
  GoogleMapActivity = public class(MapActivity)
  private
    var map: MapView;
  protected
    method isLocationDisplayed: Boolean; override;
    method isRouteDisplayed: Boolean; override;
  public
    method onCreate(savedInstanceState: Bundle); override;
    method onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean; override;
  end;

implementation

method GoogleMapActivity.onCreate(savedInstanceState: Bundle);
begin
  inherited;
  // Set our view from the "GoogleMapActivity" layout resource
  ContentView := R.layout.googlemapactivity;
  map := MapView(findViewById(R.id.mapView));
  map.BuiltInZoomControls := true;
  map.Satellite := True;
  var controller := map.Controller;
  controller.Zoom := 15;
end;

method GoogleMapActivity.isLocationDisplayed: Boolean;
begin
  exit false
end;

method GoogleMapActivity.isRouteDisplayed: Boolean;
begin
  exit false
end;

method GoogleMapActivity.onKeyDown(keyCode: Integer; &event: KeyEvent): Boolean;
begin
  case keyCode of 
    KeyEvent.KEYCODE_3: map.Controller.zoomIn;
    KeyEvent.KEYCODE_1: map.Controller.zoomOut;
  end;
  exit inherited;
end;

end.
