//#define STD_ASYNC_MODEL

using System;
using System.Drawing;

using MonoTouch.Foundation;
using MonoTouch.UIKit;

using WebServices.www.w3schools.com;

namespace WebServices
{
	public partial class FlipsideViewController : UIViewController
	{
		private TempConvert Converter;
		
		public FlipsideViewController () : base ("FlipsideViewController", null)
		{
		}
		
		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			
			// Perform any additional setup after loading the view, typically from a nib.
			resultLabel.Text = "";
			Converter = new TempConvert ();
#if !STD_ASYNC_MODEL
			Converter.CelsiusToFahrenheitCompleted += HandleConverterCelsiusToFahrenheitCompleted;
			Converter.FahrenheitToCelsiusCompleted += HandleConverterFahrenheitToCelsiusCompleted;
#endif
			convertButton.TouchUpInside += HandleConvertButtonTouchUpInside;
			convertButton.TouchUpInside += AnyNonTextControlTouched;
			conversionSelectionButton.ValueChanged += AnyNonTextControlTouched;
		}
		
		public override bool ShouldAutorotateToInterfaceOrientation (UIInterfaceOrientation toInterfaceOrientation)
		{
			// Return true for supported orientations
			return (toInterfaceOrientation != UIInterfaceOrientation.PortraitUpsideDown);
		}
		
		public override void DidReceiveMemoryWarning ()
		{
			// Releases the view if it doesn't have a superview.
			base.DidReceiveMemoryWarning ();
			
			// Release any cached data, images, etc that aren't in use.
		}
		
		public override void ViewDidUnload ()
		{
			base.ViewDidUnload ();
			
			// Clear any references to subviews of the main view in order to
			// allow the Garbage Collector to collect them sooner.
			//
			// e.g. myOutlet.Dispose (); myOutlet = null;
			
			ReleaseDesignerOutlets ();
		}
		
		partial void done (UIBarButtonItem sender)
		{
			if (Done != null)
				Done (this, EventArgs.Empty);
		}
		
		public event EventHandler Done;
		
		void HandleConvertButtonTouchUpInside (object sender, EventArgs e)
		{
			resultLabel.Text = "";
			double inputTemp;
			if (double.TryParse (temperatureTextBox.Text, out inputTemp)) {
				UIApplication.SharedApplication.NetworkActivityIndicatorVisible = true;
				activityIndicator.StartAnimating ();
#if STD_ASYNC_MODEL
				if (conversionSelectionButton.SelectedSegment == 0)
					Converter.BeginCelsiusToFahrenheit (temperatureTextBox.Text, FinishedTemperatureConversion, true);
				else
					Converter.BeginFahrenheitToCelsius (temperatureTextBox.Text, FinishedTemperatureConversion, false);
#else
				if (conversionSelectionButton.SelectedSegment == 0)
					Converter.CelsiusToFahrenheitAsync (temperatureTextBox.Text);
				else
					Converter.FahrenheitToCelsiusAsync (temperatureTextBox.Text);

#endif
			} else
				resultLabel.Text = "Invalid input temperature";
		}
		
#if STD_ASYNC_MODEL
		private void FinishedTemperatureConversion (IAsyncResult asyncResult)
		{
			var fromCelsius = (bool)asyncResult.AsyncState;
			var answer = fromCelsius ? 
        		Converter.EndCelsiusToFahrenheit (asyncResult) : 
					Converter.EndFahrenheitToCelsius (asyncResult);
			// Since we are running on a separate thread, we can not access UIKit
			// objects from here, so we need to invoke those on the main thread:
			InvokeOnMainThread (() => {
				resultLabel.Text = string.Format (fromCelsius ? "{0}°C is {1:F2}°F" : "{0}°F is {1:F2}°C",
            temperatureTextBox.Text, Convert.ToDouble (answer));
				UIApplication.SharedApplication.NetworkActivityIndicatorVisible = false;
				activityIndicator.StopAnimating ();
			});
		}
#else
		void HandleConverterCelsiusToFahrenheitCompleted (object sender, CelsiusToFahrenheitCompletedEventArgs args)
		{
			InvokeOnMainThread (() =>
			{
				resultLabel.Text = string.Format ("{0}°C is {1:F2}°F", temperatureTextBox.Text, Convert.ToDouble (args.Result));
				UIApplication.SharedApplication.NetworkActivityIndicatorVisible = false;
				activityIndicator.StopAnimating ();
			});
		}
 
		void HandleConverterFahrenheitToCelsiusCompleted (object sender, FahrenheitToCelsiusCompletedEventArgs args)
		{
			InvokeOnMainThread (() =>
			{
				resultLabel.Text = string.Format ("{0}°F is {1:F2}°C", temperatureTextBox.Text, Convert.ToDouble (args.Result));
				UIApplication.SharedApplication.NetworkActivityIndicatorVisible = false;
				activityIndicator.StopAnimating ();
			});
		}

#endif
		
		private void AnyNonTextControlTouched (object sender, EventArgs e)
		{
			temperatureTextBox.ResignFirstResponder ();
		}

	}
}
