using System;
using System.Drawing;

using MonoTouch.Foundation;
using MonoTouch.UIKit;

namespace HelloWorld
{
	public partial class HelloWorldViewController : UIViewController
	{
		public HelloWorldViewController () : base ("HelloWorldViewController", null)
		{
		}
		
		public override void DidReceiveMemoryWarning ()
		{
			// Releases the view if it doesn't have a superview.
			base.DidReceiveMemoryWarning ();
			
			// Release any cached data, images, etc that aren't in use.
		}
		
		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			
			// Perform any additional setup after loading the view, typically from a nib.
			UIApplication.SharedApplication.StatusBarStyle = UIStatusBarStyle.BlackOpaque;
			myLabel.Text = "";
			myButton.SetTitle (myButton.Title (UIControlState.Normal) + "!", UIControlState.Normal);
			myTextBox.ShouldReturn = (textField => textField.ResignFirstResponder ());
			myButton.TouchUpInside += (s, e) => {
				InfoAlert ("Hello " + myTextBox.Text); };
		}
		
		public override void ViewDidUnload ()
		{
			base.ViewDidUnload ();
			
			// Clear any references to subviews of the main view in order to
			// allow the Garbage Collector to collect them sooner.
			//
			// e.g. myOutlet.Dispose (); myOutlet = null;
			
			ReleaseDesignerOutlets ();
		}
		
		public override bool ShouldAutorotateToInterfaceOrientation (UIInterfaceOrientation toInterfaceOrientation)
		{
			// Return true for supported orientations
			return (toInterfaceOrientation != UIInterfaceOrientation.PortraitUpsideDown);
		}
		
		partial void myButtonPressed (MonoTouch.Foundation.NSObject sender)
		{
			myLabel.Text = "Hello world! Erm, I mean Hello " + myTextBox.Text + "!";
			if (myTextBox.IsFirstResponder)
				myTextBox.ResignFirstResponder ();
		}
		
		private void InfoAlert (string msg)
		{
			using (UIAlertView av = new UIAlertView("Info", msg, null, "OK", null)) {
				av.Show ();
			}
		}

	}
}
